var samplePageObj = {
  // 샘플 타이틀
  title: '정규식(RegExp) 를 이용한 검증',
  subtitle: '사용자 입력시 정규식을 이용하여 검증합니다.',
  // 샘플 설명
  desc: 'EditMask,ResultMask 속성을 통해 사용자가 입력하는 값에 대해 유효성을 검증할 수 있습니다.<br>'
  + '유효성 검증에 실패시 ResultMessage나 ResultText를 통해 입력해야 하는 형식을 사용자에게 알려줄 수 있습니다.<br>'
  + '현재 샘플에서는 각 컬럼에 EditMask,ResultMask를 설정해 두고 있습니다. 컬럼에 마우스커서를 올려 풍선도움말을 참고해 주세요.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SeachMode: 0,
      Alternate: 2
    },
    Def: {
      Col: {
      }
    },
    LeftCols: [
      {
      // 컬럼 헤더 설정
        Header: 'No.', // 헤더 로우의 SEQ 컬럼에 해당하는 셀에 표시될 title 값
        Name: 'SEQ', // colName 컬럼명을 설정 (Data와 Matching)
        RelWidth: 0,
        Type: 'Int', // 컬럼 타입 설정 : Html, Text, Int, Float, Button, Lines, Enum, Radio, Img, Link, Icon, Bool
        Width: 80, // 컬럼의 너비 기본 너비 설정(px)
        Align: 'Center' // 컬럼의 내용 정렬 방식 설정 {"Left": 좌측 정렬,"Center": 가운데 정렬,"Right": 우측 정렬}
      }
    ],
    Cols: [
      {
        Header: '아이디',
        Name: 'sId',
        Type: 'Text',
        Width: 120,
        // Color:"#FFEEEE",
        EditMask: '^[a-z|0-9]*$', // 편집 중에 입력되는 값에 대한 마스크
        ResultMask: '^[a-z](([0-9|a-z]){5,9})$', // 편집 완료했을때 셀 값을 검사하는 마스크
        ResultText: '아이디는 6~10글자 이내의 영소문자,숫자로 작성해주세요.(첫글자는 영문자로 시작)',
        Tip: '아이디는 6~10글자 이내의 영소문자나 숫자로 작성해주세요.(첫글자는 영문자로 시작)' // 셀 위에 마우스를 올렸을때 나타나는 툴팁의 문자열입니다.
      },

      {
        Header: '근무지',
        Name: 'sZone',
        Type: 'Text',
        Width: 80,
        Button: 'Defaults',
        Format: {
          AA: '서울',
          BB: '울산',
          CC: '평택',
          DD: '제주',
          EE: '대전',
          FF: '전주'
        }, // 화면에 표시될 셀 값의 Format 형태를 설정. 값이 AA면 '서울'이 화면에 표시
        EditFormat: {
          AA: '서울',
          BB: '울산',
          CC: '평택',
          DD: '제주',
          EE: '대전',
          FF: '전주'
        }, // 셀 편집시 화면에 표시될 Format 형태를 설정
        Defaults: '|AA|BB|CC|DD|EE|FF', // 셀 선택시 기본값
        ResultMask: '^(AA|BB|CC|DD|EE|FF|서울|울산|평택|제주|대전|전주)$',
        ResultText: '입력된 근무지를 확인해주세요.', // 편집 후 결과 값이 ResultMask에 설정된 조건과 맞지 않을때 발생하는 메시지 (native.alert)
        Tip: '서울,울산,평택,제주,대전,전주 중에 하나를 입력해 주세요.',

      },
      {
        Header: '년월일',
        Name: 'sDate_Ymd',
        Type: 'Date',
        Width: 120,
        Format: 'yyyy/MM/dd', // 화면에 표시될 셀 값의 Format 형태를 설정
        Size: 8, // 셀에 입력할 수 있는 값의 길이 제한
        DataFormat: 'yyyyMMdd', // 시트에 넣어질 Date 타입 데이터의 형식 **사용자의 데이터가 2018-07-20이면 yyyy-MM-dd로 설정
        EditMask: '^\\d*$', // 편집 시 화면에 표시될 값에 대한 마스크
        ResultMask: '^[0-9][0-9][0-9][0-9][01][0-9][0-3][0-9]$',
        ResultMessage: '입력된 날짜를 확인해주세요.', // 편집 후 결과 값이 ResultMask에 설정된 조건과 맞지 않을때 발생하는 메시지
        ResultMessageTime: 0, // ResultMessage의 지속시간. ** 0으로 설정시 버튼을 눌러야 창이 종료됩니다.
        Tip: '8개의 숫자를 구분자 없이 입력해 주세요.'
      },
      {
        Header: 'E-Mail',
        Type: 'Text',
        Name: 'sEmail',
        // Color:"#FFEEEE",
        RelWidth: 1, // 컬럼에 들어가는 셀의 상대적인 크기 설정 (자유로운 기준치를 설정가능)
        ResultMask: '^[\\w\\.\\+%-]+@[A-Za-z0-9\\.-]+\\.[A-Za-z]{2,6}$',
        ResultMessage: '이메일 주소를 확인해 주세요.',
        ResultMessageTime: 800,
        Tip: '이메일 주소를 형식에 맞게 입력해 주세요.'
      },
      {
        Header: '등급',
        Type: 'Int',
        Name: 'sGrade',
        Align: 'Center',
        Width: 80,
        ResultMask: '^[1-9]$',
        ResultMessage: '등급은 1부터 9까지만 입력이 가능합니다.',
        ResultMessageTime: 1000,
        Tip: '등급은 1부터 9까지만 입력이 가능합니다.'
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 속성
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
    onResultMask: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      if (evtParam.col === 'sId') {
        // sId 컬럼의 ResultMask 설정에 의한 유효성 검사를 통과하지 못한 경우
        // alert 메시지 창을 띄우지 않고 편집모드를 계속 진행
        // return 1 인 경우 ResultText나 ResultMessage가 동작하지 않는다.
        return 0;
      }
    }
  },

  // data
  data: [
    {
      sId: 'sagittis',
      sZone: '서울',
      sDate_Ymd: '20150526',
      sEmail: 'In.ornare.sagittis@sapien.co.uk',
      sGrade: 2
    },
    {
      sId: 'fairytale',
      sZone: '전주',
      sDate_Ymd: '20110126',
      sEmail: 'quam.quis.diam@justonec.ca',
      sGrade: 3
    },
    {
      sId: 'willsmith',
      sZone: '전주',
      sDate_Ymd: '20160715',
      sEmail: 'id@massalobortisultrices.com',
      sGrade: 2
    },
    {
      sId: 'princess',
      sZone: '서울',
      sDate_Ymd: '20160701',
      sEmail: 'non@Integerid.com',
      sGrade: 1
    },
    {
      sId: 'libero',
      sZone: '대전',
      sDate_Ymd: '20130423',
      sEmail: 'libero@ipsumprimisin.ca',
      sGrade: 1
    },
    {
      sId: 'joseph',
      sZone: '울산',
      sDate_Ymd: '20150526',
      sEmail: 'et.malesuada@imperdietullamcorperDuis.net',
      sGrade: 8
    },
    {
      sId: 'senectus',
      sZone: '제주',
      sDate_Ymd: '20110126',
      sEmail: 'senectus@utquamvel.ca',
      sGrade: 9
    },
    {
      sId: 'tellus',
      sZone: '서울',
      sDate_Ymd: '20160715',
      sEmail: 'tellus.non.magna@ut.ca',
      sGrade: 7
    },
    {
      sId: 'bktech',
      sZone: '제주',
      sDate_Ymd: '20160701',
      sEmail: 'nec.malesuada@Aliquam.ca',
      sGrade: 1
    },
    {
      sId: 'jackson',
      sZone: '서울',
      sDate_Ymd: '20130423',
      sEmail: 'tincidunt.pede.ac@adipiscingelit.ca',
      sGrade: 1
    },
    {
      sId: 'susanboyle',
      sZone: '서울',
      sDate_Ymd: '20150526',
      sEmail: 'porta.elit.a@at.org',
      sGrade: 1
    },
    {
      sId: 'aenean',
      sZone: '서울',
      sDate_Ymd: '20110126',
      sEmail: 'Aenean.eget@montes.net',
      sGrade: 1
    },
    {
      sId: 'ericmaire',
      sZone: '평택',
      sDate_Ymd: '20160715',
      sEmail: 'rutrum.lorem.ac@Cumsociisnatoque.com',
      sGrade: 1
    },
    {
      sId: 'booster',
      sZone: '서울',
      sDate_Ymd: '20160701',
      sEmail: 'amet@Aeneangravidanunc.com',
      sGrade: 1
    },
    {
      sId: 'guillaume',
      sZone: '평택',
      sDate_Ymd: '20130423',
      sEmail: 'Proin@Donecconsectetuermauris.com',
      sGrade: 1
    },
    {
      sId: 'fantastic',
      sZone: '제주',
      sDate_Ymd: '20150526',
      sEmail: 'penatibus.et@elitpede.com',
      sGrade: 1
    },
    {
      sId: 'donald',
      sZone: '서울',
      sDate_Ymd: '20110126',
      sEmail: 'lorem.Donec.elementum@Donecdignissimmagna.edu',
      sGrade: 1
    },
    {
      sId: 'attwitch',
      sZone: '울산',
      sDate_Ymd: '20160715',
      sEmail: 'neque.non@vellectus.co.uk',
      sGrade: 1
    },
    {
      sId: 'algolia',
      sZone: '서울',
      sDate_Ymd: '20160701',
      sEmail: 'neque.Morbi@Nullamscelerisqueneque.org',
      sGrade: 1
    },
    {
      sId: 'stripe',
      sZone: '제주',
      sDate_Ymd: '20130423',
      sEmail: 'Nam@arcuMorbisit.org',
      sGrade: 1
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
